<%--
 This JSP is responsible for closing a task window when the task currently
 has no panels to display.  If the user is disconnecting or logging off, it
 also closes all the other browser windows associated with HMC tasks.
 The Task Interface dispatches to this page when appropriate.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <hmc:title>Closing Task Window</hmc:title>
   <meta http-equiv="Cache-Control" content="no-cache">
   <script type="text/javascript" src="/js/task/taskWindow.js"></script>
</head>
<body>

<%--
 If we're in disconnect/logoff processing, we also close windows for the main
 UI window and every running task.  We transfer the relevant information from
 the request parameters to the JavaScript code.
--%>
<c:if test="${not empty windowNames}">
<script type="text/javascript">
   var windowNames = [
    <c:forEach var="name" varStatus="loopStatus" items="${windowNames}">
       "<c:out value='${name}'/>" <c:if test="${!loopStatus.last}">,</c:if>
    </c:forEach>
       ];
</script>
</c:if>

<script type="text/javascript">
   mw = getHMCMainWindow(window);

   <c:if test="${not empty windowNames}">
      for (var i=0; i<windowNames.length; ++i) {
         try {
            taskwin = window.open("", windowNames[i]);
            taskwin.onunload = "";
            taskwin.onbeforeunload = "";
            taskwin.hmcWindowIsClosed = "Y";
            taskwin.close();
         } catch (e) {
            // Ignore exceptions
         }
      }

      // If closing the window killed all JavaScript running as part of that
      // window, then we could set "mw" to null here to avoid calls to
      // markWindowCloseHandled() below.  But on some browsers, closing the
      // window apparently doesn't end all JavaScript timers, at least not
      // right away.  So we don't touch "mw".
   </c:if>

   // Close this task's window
   try {
      if (mw != null && "markWindowCloseHandled" in mw) {
         mw.markWindowCloseHandled(window.name);
      }
   } catch (e) {
      // Ignore exceptions
   }

   window.onunload = "";
   window.onbeforeunload = "";
   window.close();
</script>

<fmt:message key="closingWindowMessage"/>

</body>
</html>
</fmt:bundle>
